/* lcd_functions.c */
                   
#include "lcd.h"
#include "MC9S08GW64.h"

extern unsigned char ir_command;

extern unsigned char blinkindex;
/////////////////////////////////////////////////////////////////////////////////////////
// LCDInit
// --------------------------------------------------------------------------------------
// LCD Peripheral Initialization
/////////////////////////////////////////////////////////////////////////////////////////

void LCDInit()
{ 

  SCGC2_LCD = 1;            //enables the clock to LCD module
 
  LCDC0_SOURCE = LCD_CLOCK;
    
  LCDC0_DUTY = (LCD_NO_OF_BACK_PLANES - 1);     //Duty cycle is adjusted according to the no of back planes
  
  CONFIG_LCD_MODE                          //configures 21x8 mode if 29 pin lCD used
  
  LCDSUPPLY_VSUPPLY = LCD_VSUPPLY;  //derive VLL1,2 and 3 from VLCD
  
  LCDC0_LCLK= LCD_CLOCK_PRESCALER;
  
  LCDSUPPLY_LADJ=LCD_LOAD_ADJUST;
 
  LCDSUPPLY_CPSEL = LCD_CHARGE_PUMP_SELECT;      //selects between charge pump & resistor bias 
    
  LCDC0_LCDEN = 1;         //LCDEN starts LCD-module-waveform generator
    
}
/////////////////////////////////////////////////////////////////////////////////////////
// LCDBlinkState
// --------------------------------------------------------------------------------------
// Enable LCD Segments Blink State Mode
/////////////////////////////////////////////////////////////////////////////////////////
void LCDBlinkState(void)
{
  
  //Selects LCDRAM registers that control LCD segments blink state (LCDDRMS=1)
  LCDBCTL = 0x2;
  
  //Starts LCD module blinking (BLINK=1)
  LCDBCTL_BLINK = 0x1;
  
}
/////////////////////////////////////////////////////////////////////////////////////////
// lcd_StopBlinking
// --------------------------------------------------------------------------------------
// Disables LCD Segments Blink State Mode
/////////////////////////////////////////////////////////////////////////////////////////

void lcd_StopBlinking()
{
  LCDBCTL &= ~0x80;

}


/////////////////////////////////////////////////////////////////////////////////////////
// LCDOnOffState
// --------------------------------------------------------------------------------------
// Enable LCD Segments ON/OFF State Mode
/////////////////////////////////////////////////////////////////////////////////////////
void LCDOnOffState(void)
{

  //Stop LCD module blinking (BLINK=0)
  LCDBCTL &= ~0x80;
  
  //Selects LCDRAM registers that control LCD segments on/off state (LCDDRMS=0)
  //LCDCMD = 0x00;

}

/////////////////////////////////////////////////////////////////////////////////////////
// LCDClear
// --------------------------------------------------------------------------------------
// Clear LCDRAM Registers
/////////////////////////////////////////////////////////////////////////////////////////
void LCDClear(void)
{

  LCD_ALLFP_OFF      //all segments are off
    
}

/////////////////////////////////////////////////////////////////////////////////////////
// LCDScrollNumbersAndAlphabetbets
// --------------------------------------------------------------------------------------
// Scrolls the digits and alphabets on the LCD screen at the position mentioned
/////////////////////////////////////////////////////////////////////////////////////////

void LCDScrollNumbersAndAlphabetbets(unsigned char digit)
{
  char c= 'A';
  unsigned char i;

  for(i='0';i<='9';i++)
  {
    LCDClearDigit(digit);
    LCDPutChar(i, digit);
    Delay(65);
  }
  
  for(;c<='Z';c++)
  {
    LCDClearDigit(digit);
    LCDPutChar(c, digit);
    Delay(65);
  }
}

/////////////////////////////////////////////////////////////////////////////////////////
// LCDKey1Func
// --------------------------------------------------------------------------------------
// Scrolls the digits and alphabets on the LCD screen at all the positions one by one
/////////////////////////////////////////////////////////////////////////////////////////


void LCDKey1Func()
{
  unsigned char digit = 1;
  
  LCD_ALLFP_OFF
  
  while(digit<=9)
  {
    LCDScrollNumbersAndAlphabetbets(digit);
    digit++;
  }
}

/////////////////////////////////////////////////////////////////////////////////////////
// LCDDiagnosticFunc
// --------------------------------------------------------------------------------------
// A function to test the LCD functionality by first glowing the special segments then
//scrolling al the digits and alphabets one by one
/////////////////////////////////////////////////////////////////////////////////////////

void LCDDiagnosticFunc(void)
{
 
  
  LCDTest();     // Special segments only
  
  Delay(10);
  
  LCDKey1Func();     //All segment glow with special segments
}


/////////////////////////////////////////////////////////////////////////////////////////
// PrintString
// --------------------------------------------------------------------------------------
// Prints a string on the LCD
/////////////////////////////////////////////////////////////////////////////////////////

void lcd_PrintString(unsigned char *str)
{
  unsigned char i;
  /*for(i = 0; str[1] != 0;i++)
    ;*/
  for(i = 0; str[i] != 0;)
  {
    LCDPutChar(str[i], ++i);
  }
  while(i<=NUM_DIGITS)
  {
    LCDPutChar(' ', ++i);
  }
  
}

/////////////////////////////////////////////////////////////////////////////////////////
// SlideString
// --------------------------------------------------------------------------------------
// Slides strings on the LCD
/////////////////////////////////////////////////////////////////////////////////////////
void lcd_SlideString(unsigned char *str)
{

  unsigned char i, j, start;

  for(i = 0; str[i] != 0; i++) 
  {
    //Delay(d);
    LCDClear();
    if(i < NUM_DIGITS) 
      start = 0;
    else  
      start = i-NUM_DIGITS+1; 
    for(j = start; j <= i; j++)
      LCDPutChar(str[j], NUM_DIGITS-i+j);
  }
}

/////////////////////////////////////////////////////////////////////////////////////////
// DispHexVal
// --------------------------------------------------------------------------------------
// Displays the hex value of the character eneterd
/////////////////////////////////////////////////////////////////////////////////////////

void DispHexVal(unsigned char val, unsigned char startloc)
{

  unsigned char ch[2];
    
  // High value
  if((val>>4) < 0x0A)
    ch[1] = '0' + (val>>4);
  else
    ch[1] = 'A' + (val>>4) - 0x0A;
  // Low value
  if((val&0x0F) < 0x0A)
    ch[0] = '0' + (val&0x0F);
  else
    ch[0] = 'A' + (val&0x0F) - 0x0A;
  
  LCDPutChar(ch[1], startloc);
  LCDPutChar(ch[0], startloc+1);
  
}

/////////////////////////////////////////////////////////////////////////////////////////
// DispDecVal
// --------------------------------------------------------------------------------------
// Displays the decimal value of the character entered
/////////////////////////////////////////////////////////////////////////////////////////

void DispDecVal(unsigned char val, unsigned char startloc)
{

  unsigned char ch[2],i,tempchar,location;
    
  // High value
  ch[0] = '0' + (val/10);
  // Low value
  ch[1] = '0' + (val%10);
  
  for(i = 0; i <= 1; i++)
  {
    location = startloc+i;
    tempchar = ch[i];

    if((location) == blinkindex)
      LCDPutChar(tempchar, location);
    else
      LCDPutChar(' ', location);

    LCDPutChar(tempchar, location);
  }
}


